function data = test_me()
    %% takes entirely automatic picture
    %% displays all data in verbose mode
    disp('Peeping ROM test function.');
    disp('Hardware by Jim Paris;');
    disp('Software by Jim Paris & Andrew Muth.');
    disp('');

    %% variable setup
    clear raw_pic;
    clear color_pic;
    clear hist;

    %% camera picture algorithm
    camera_setup;  % <--- set serial port here, if desired
    
    %% automatic mode enables
    disp('-----');
    pr_modeset('AEC','enabled','AGC','enabled','AWB','enabled','verbose');
    disp('-----');

    %% display registers during settling period
    disp('Registers displayed:');
    disp('time: 0x01 : 0x02 : 0x05 : 0x06 : 0x07 : 0x10 : 0x00');            
    for i = 10 : -1 : 1  
        bluegain = pr_get(hex2dec('01'));
        redgain = pr_get(hex2dec('02'));
        contrast = pr_get(hex2dec('05'));
        brightness = pr_get(hex2dec('06'));
        sharpness = pr_get(hex2dec('07'));
        autoexpose = pr_get(hex2dec('10'));
        gain = pr_get(hex2dec('00')); 
        disp(sprintf('  %02d:  %02X     %02X     %02X     %02X     %02X     %02X     %02X',[i,bluegain,redgain,contrast,brightness,sharpness,autoexpose,gain]));
        pause(1);
     end
    
    %% capture picture
    raw_pic = camera_takepic;
    
    %% image interpolation algorithm from Jim
    [ color_pic(:,:,1) color_pic(:,:,2) color_pic(:,:,3) red_raw green_raw blue_raw ] = feval('bayer',raw_pic);
    
    %% display raw pic, color pic, and histogram
    pr_display(raw_pic, 'Raw Data', 1000);
    pr_display(color_pic, 'Final Image', 1001);
    hist = histogram(color_pic, 1002);
    
    %% done working
    disp('Done.');
