function data = test(serialport)

  %% Make pic a global so we can still use it after downloading
  clear raw_pic;
  clear color_pic;
  clear global raw_pic;
  clear global color_pic;
  global raw_pic;
  global color_pic;

  %% Initialize camera
  if (nargin == 1)
      pr_init(serialport);
  else
      pr_init;
  end
  
  pr_reinit;
  
  %% testing
  disp('-----');
  pr_modeset('AEC','enabled','AGC','enabled','AWB','enabled','verbose');
  disp('-----');
  
  %turn on indoor mode
  disp('Applying user-specified changes...');
  

 
  %% Wait 10 seconds for auto-levels to settle
  for i = 10 : -1 : 1  
    bluegain = pr_get(hex2dec('01'));
    redgain = pr_get(hex2dec('02'));
    contrast = pr_get(hex2dec('05'));
    brightness = pr_get(hex2dec('06'));
    sharpness = pr_get(hex2dec('07'));
    autoexpose = pr_get(hex2dec('10'));
    gain = pr_get(hex2dec('00'));
    disp(sprintf('%d: %02d %02d %02d %02d %02d %02d %02d ',[i,bluegain,redgain,contrast,brightness,sharpness,autoexpose,gain]));
    pause(1);
  end

  %% Take picture
  disp('Picture');
  
  pr_picture;
  
  %% Download image
  disp('Downloading');
  t_start = clock;
  raw_pic = reshape(pr_download(349*288),349,288)';
  download_time = etime(clock, t_start);
  disp(sprintf('Total download time: %d seconds.',[round(download_time)]));
%  pic = reshape(pr_download(349*50),349,50)';

  %% Decode Bayer pattern and display
  disp('Displaying');
  [ color_pic(:,:,1) color_pic(:,:,2) color_pic(:,:,3) red_raw green_raw blue_raw ] = feval('bayer',raw_pic);
  %% pr_display(color_pic);
  pr_showpics(raw_pic, color_pic, red_raw, green_raw, blue_raw);

  % Saves test image as a .jpg file
  % imwrite(tmp, sprintf('C:\\Documents and Settings\\UROP\\Desktop\\camera\\testdata\\photo%02d.jpg',[counter]), 'quality', 100);
  
  %% Close camera
  pr_close;
  disp('All done');
end