function data = camera_showpics(raw_image, color_image, red_raw, green_raw, blue_raw)
    %% shows 5 photos for each picture taken:
    %% raw-red, raw-green, raw-blue,
    %% bayer-red, bayer-green, bayer-blue
    %% raw-bw, bayer-bw, full-image
    %% uses figures 1000-1008
    %% assumes MxN matrix for raw, MxNx3 for color
    disp('Displaying all image data...');
    
    %% after interpolation using bayer
    r_raw = zeros(length(red_raw(:,1)),length(red_raw),3);
    r_raw(:,:,1) = red_raw(:,:,1);
    g_raw = zeros(length(green_raw(:,1)),length(green_raw),3);
    g_raw(:,:,2) = green_raw(:,:,1);
    b_raw = zeros(length(blue_raw(:,1)),length(blue_raw),3);
    b_raw(:,:,3) = blue_raw(:,:,1);    
    
    %% after interpolation using bayer
    red_channel = zeros(length(color_image(:,1)),length(color_image),3);
    red_channel(:,:,1) = color_image(:,:,1);
    green_channel = zeros(length(color_image(:,1)),length(color_image),3);
    green_channel(:,:,2) = color_image(:,:,2);
    blue_channel = zeros(length(color_image(:,1)),length(color_image),3);
    blue_channel(:,:,3) = color_image(:,:,3);
    
    %% now display everything
    pr_display(raw_image, 'Raw Data', 1000);
    pr_display(r_raw, 'Raw Red Channel', 1001);
    pr_display(g_raw, 'Raw Green Channel', 1002);
    pr_display(b_raw, 'Raw Blue Channel', 1003);
    pr_display(red_channel, 'Post-Bayer Red Channel', 1004);
    pr_display(green_channel, 'Post-Bayer Green Channel', 1005);
    pr_display(blue_channel, 'Post-Bayer Blue Channel', 1006);
    pr_display(color_image, 'Final Interpolated Image', 1007);
    
    
