function data = pr_regset(register, value, mode)
    %% sets register to specific value
    %% call: pr_regset(<reg>,<value>,['verbose'/'quiet'])
    %% option for verbose output:
    %% <initial value, value written, new value>
    %% also notifies if written value isn't read back

    %% hex->dec conversion information
    %% if register is characters, hex2dec it
    %% otherwise, decimal input
    if (ischar(register))
        register = hex2dec(register);
    end
    %% same with value argument
    if (ischar(value))
        value = hex2dec(value);
    end
    
    %% actual register setting, etc
    if (nargin < 2)
        error('Not enough information to set register!');
    elseif (nargin == 3)
        switch mode
            case 'verbose'
                %% verbose mode
                old_value = pr_get(register);
                pr_set(register, value);  %changes register 
                new_value = pr_get(register);
                %%now display the information
                disp(sprintf('Register 0x%02X: originally %02d, set to %02d, new value %02d', [register, old_value, value, new_value]));
            case 'quiet'
                %% not verbose, just warn on bad readback
                old_value = pr_get(register);
                pr_set(register, value);  %changes register 
                new_value = pr_get(register);
                %% warn on bad readback
                if (value ~= new_value)
                    warning('Register 0x%02X set to %02d but reads %02d.  Expected?', register, value, new_value);
                end
            otherwise
                warning('%s passed as argument to pr_regset; using verbose mode.',mode);
                %% verbose mode
                old_value = pr_get(register);
                pr_set(register, value);  %changes register 
                new_value = pr_get(register);
                %%now display the information
                disp(sprintf('Register 0x%02X: originally %02d, set to %02d, new value %02d', [register, old_value, value, new_value]));
        end
    else
        %% not verbose, just warn on bad readback
        old_value = pr_get(register);
        pr_set(register, value);  %changes register 
        new_value = pr_get(register);
        %% warn on bad readback
        if (value ~= new_value)
            warning('Register 0x%02X set to %02d but reads %02d.  Expected?', register, value, new_value);
        end
    end