function data = pr_modeset(mode_1,state_1,mode_2,state_2,mode_3,state_3,mode)
    %% Sets up entire automode system and gives
    %% back useful info to the operator.
    %% Expects variable number of arguments of type
    %%  <system>,<status> --> ...'AEC','disable',...
    %% AEC, AWB, AGC options
    
    % starts with all modes enabled!
    disp('NOTE: all automatic modes are enabled on startup!');
    
    for i = 1:(nargin/2)
        %% sets right arguments into variables for testing
        if (nargin < 7)
            mode = 'quiet';
        end
        if ((nargin > 7) | ((nargin ~= 7) & (mod(nargin,2) ~= 0)))
            error('%d arguments supplied to pr_modeset; 3 argument PAIRS expected.',nargin);
        elseif (i == 1) 
            x = mode_1;
            y = state_1;
        elseif (i == 2)
            x = mode_2;
            y = state_2;
        elseif (i == 3)
            x = mode_3;
            y = state_3; 
        end
        %% parses arguments and sets camera
        %% NOTE! bitset(..) is 1-indexed, while OV6630 datasheet is
        %% 0-indexed!
        switch x
            case 'AEC'
                %% register 0x29: COMI[7] is AEC DISABLE if 1
                switch y
                    case 'enabled' %COMI[7] = 0
                        old_value = pr_get(hex2dec('29'));
                        new_value = bitset(old_value,8,0);
                        pr_regset('29',new_value,mode);
                        disp('Auto Exposure Control operational.');
                    case 'disabled' %COMI[7] = 1
                        old_value = pr_get(hex2dec('29'));
                        new_value = bitset(old_value,8,1);
                        pr_regset('29',new_value,mode);
                        disp('Auto Exposure Control disabled.');
                    otherwise
                        error('%s is not an allowed option.',y);
                end
            case 'AWB'
                switch y
                    %% register 0x12: COMA[2] is AWB ENABLE if 1
                    case 'enabled'  %COMA[2] = 1
                        old_value = pr_get(hex2dec('12'));
                        new_value = bitset(old_value,3,1);
                        pr_regset('12',new_value,mode);
                        disp('Auto White Balance operational.');
                    case 'disabled' %COMA[2] = 0
                        old_value = pr_get(hex2dec('12'));
                        new_value = bitset(old_value,3,0);
                        pr_regset('12',new_value,mode);
                        disp('Auto White Balance disabled.');
                    otherwise
                        error('%s is not an allowed option.',y);                        
                end
            case 'AGC'
                switch y
                    %% register 0x12: COMA[5] is AGC ENABLE if 1
                    %% register 0x28: COMH[3] is AGC DISABLE if 1
                    case 'enabled' %COMA[5] = 1; COMH[3] = 0
                        old_value = pr_get(hex2dec('12'));
                        new_value = bitset(old_value,6,1);
                        pr_regset('12',new_value,mode);
                        old_value = pr_get(hex2dec('28'));
                        new_value = bitset(old_value,4,0);
                        pr_regset('28',new_value,mode);
                        disp('Auto Gain Control operational.');
                    case 'disabled' %COMA[5] = 0; COMH[3] = 1
                        old_value = pr_get(hex2dec('12'));
                        new_value = bitset(old_value,6,0);
                        pr_regset('12',new_value,mode);
                        old_value = pr_get(hex2dec('28'));
                        new_value = bitset(old_value,4,1);
                        pr_regset('28',new_value,mode);
                        disp('Auto Gain Control disabled.');
                    otherwise
                        error('%s is not an allowed option.',y);
                end
            otherwise
                error('%s is not an allowed option.',x);
            end                        
    end
