function pr_init(port)

  %% Check arguments
  if (nargin ~= 1)
      %% no port specified, so guess based on OS
      os_type = computer;
      switch os_type
          case 'PCWIN'
              disp('No serial port specified and MS Windows detected; attempting COM1...');
              port = 'COM1';
          case 'MAC'
              serialport = input('Macintosh OS detected; please specify serial port:');
              port = serialport;
          case {'GLNX86','GLNXA64','GLNXI64'}
              disp('No serial port specified and Linux detected; attempting /dev/ttyS0...');
              port = '/dev/ttyS0';
          otherwise
              serialport = input('Unknown OS detected; please specify serial port:');
              port = serialport;
      end
  end
  
  pr_close;

  global pr_serialobj;
  pr_serialobj=serial(port, 'BaudRate', 115200, 'DataBits', 8, ...
		      'Parity', 'none', 'StopBits', 1, 'Terminator', 'LF', ...
		      'Timeout', 10);
  fopen(pr_serialobj);
  disp('Opened serial port.');

  pr_check;
