function val = pr_get(reg)

  %% convert hex if necessary
  if(ischar(reg))
     reg = hex2dec(reg);
  end
  
  if(reg < 0 || reg > 255) 
    error 'Invalid register.';
  end

  global pr_serialobj;
  pr_flush;

  fprintf(pr_serialobj, 'G%02x\n', reg);
  line = fgetl(pr_serialobj);
  [val, ok] = sscanf(line, '%02x');
  if(ok ~= 1) 
    pr_close;
    error 'Register read failed.';
  end

