function data = pr_download(num, addr, mode)
  
  %% Check arguments
  if(nargin < 1 || num < 1 || num > 512*1024 || num ~= floor(num))
    error 'Invalid number of bytes.';
  end

  if(nargin < 2)
    addr = 0;
  end

  if(nargin < 3)
    mode = 'quiet';
  end

  if(addr < 0 || addr >= 512*1024 || addr ~= floor(addr))
    error 'Invalid starting address.';
  end

  global pr_serialobj;
  pr_flush;
  pr_dlsetup(addr);
  tic;
  chunksize = 128; % must match PIC chunk size

  %% Download the data in chunks
  data = zeros(num,1);
  for start = 1:chunksize:num
    %% Print status every 5 seconds
    if toc > 5
      disp(sprintf('%6.2f%% complete',start/num * 100));
      tic
    end
    count = chunksize;
    bytes = pr_dlchunk(count, addr + start - 1, mode);
    if (start + 128) > num
      count = num - start + 1;
    end
    data(start:(start + count - 1)) = bytes(1 : count);
  end
  disp(sprintf('%6.2f%% complete',100));

  %% Exit download mode
  fprintf(pr_serialobj, '%s\n', 'X');
  line = fgetl(pr_serialobj);
