function pr_dlsetup(addr)
  %% Initialize download at specified address

  if(addr < 0 || addr >= 512*1024 || addr ~= floor(addr))
    error 'Invalid starting address.';
  end

  global pr_serialobj;
  pr_flush;

  %% Setup the download
  cmd = sprintf('D%06x', addr);
  fprintf(pr_serialobj, '%s\n', cmd);
  line = fgetl(pr_serialobj);
  if(strcmp(line,'ok') == 0)
    error 'Download setup failed.';
  end
