function bytes = pr_dlchunk(size, addr, mode)
  %% Download a chunk of specified size, retrying if there's an error.
  %% Assumes the download has been initialized, and reinitializes to
  %% the given address only if it needs to retry.

  if(nargin < 3)
    mode = 'quiet';
  end

  if(size < 1)
    error 'Invalid chunk size.';
  end
  linesize = size * 3 - 1;

  if(addr < 0 || addr >= 512*1024 || addr ~= floor(addr))
    error 'Invalid starting address.';
  end

  global pr_serialobj;
  pr_flush;

  bad = 1;
  while bad
    bad = 0;
    fprintf(pr_serialobj, '%s\n', 'M');
    line = fgetl(pr_serialobj);
    if(length(line) ~= linesize)
      if(mode == 'verbose') 
        disp(sprintf('Warning: only got %d characters, wanted %d', ...
		     length(line), linesize));
      end
      bad = 1; 
    else
      [bytes, count] = sscanf(line, '%02x');
      if(count ~= size) 
        if(mode == 'verbose') 
	  disp(sprintf('Warning: only got %d data bytes, wanted %d', ...
		       count, size));
        end
	bad = 1;
      end
    end
    if(bad) 
      %% reinitialize download
      if(mode == 'verbose')
        disp(sprintf('Retrying download at address %06x',addr));
      end
      pr_check(0);
      pr_dlsetup(addr);
    end
  end
		 
		 