function pr_display(data, fig_name, fig_number)

  %% Display a peeping rom image in figure window fig_number (or 4321)
  %% Pass either a NxM matrix to display as greyscale, or
  %% a NxMx3 matrix to display as red, green, blue.
  %% also pass figure name as string

  [ row, col, planes ] = size(data); 
  if planes ~= 1 && planes ~= 3 
    error "Bad image data format"
  end

  %% Bring figure to front, display image, and resize
  if (nargin ~= 3)
      fig = figure(4321);
  elseif (nargin == 3)
      fig = figure(fig_number);
  else
      warning('No figure name or number passed to pr_display.');
      fig_name = 'Image';
      fig = figure(4321);
  end
  
  clf;
  image(uint8(data));
  if planes == 1 
    %% Display as grayscale
    colormap(gray(256));
  end
  rect = get(fig, 'Position');
  set(fig, 'Position', [rect(1), rect(2), col, row]);
  set(fig, 'Resize', 'on');
  set(fig, 'Name', sprintf('Peeping ROM - %s',[fig_name]));
  set(fig, 'NumberTitle', 'off');
  ha = gca;
  set(ha, 'Units', 'Normalized');
  axis image;
  axis off;
  set(ha, 'Position', [0, 0, 1, 1]);
