function pr_check(verbose)
  
  if(nargin < 1)
    verbose = 1;
  end

  global pr_serialobj;
  pr_flush;

  %% If no format string is specified, '%s\n' is assumed.
  %% Specify it manually to avoid confusion.
  fprintf(pr_serialobj, '%s\n', 'V'); 
  line = fgetl(pr_serialobj);
  if(strncmp(line,'ver ',4) == 0)
    pr_close;
    error 'Invalid or no response from camera.  Check connections.';
  end
  if(strcmp(line,'ver 02') == 0)
    pr_close;
    error('Wrong camera firmware version "%s", expected "ver 02"',line);
  end
  if(verbose)
	  disp('Camera firmware 02 detected.');
  end

