function data = pr_bitset(register,bit,value,mode)
    %% bitwise operations on register
    %% call: pr_regset(<reg>,<0-index-bit#>,<value>,['verbose'/'quiet'])
    %% option for verbose output:
    %% <initial value, value written, new value>
    %% also notifies if written value isn't read back
    
    %% hex->dec conversion information
    %% if input is character string, convert hex to dec
    %% otherwise, decimal input
    if (ischar(register))
        register = hex2dec(register);
    end
    
    %% actual bit setting, etc
    if (nargin < 3)
        error('Not enough information to set register!');
    elseif (nargin == 4)
        old_value = pr_get(register);
        new_value = bitset(old_value,(bit+1),value);
        pr_regset(register,new_value,mode);
    else
        mode = 'quiet';
        old_value = pr_get(register);
        new_value = bitset(old_value,(bit+1),value);
        pr_regset(register,new_value,mode);
    end