function [raw_pic, color_pic, hist] = picture_me()
    %% call picture_me to take a picture
    disp('Peeping ROM image capture function.');
    disp('Hardware by Jim Paris;');
    disp('Software by Jim Paris & Andrew Muth.');
    disp('');

    %% variable inits
    clear raw_pic;
    clear color_pic;
    clear hist;

    %% camera picture algorithm
    camera_setup;  % <--- set serial port here, if desired
    camera_usermode('verbose');  % <--- enter user changes in this function!
    raw_pic = camera_takepic;
    
    %% image interpolation algorithm from Jim
    [ color_pic(:,:,1) color_pic(:,:,2) color_pic(:,:,3) red_raw green_raw blue_raw ] = feval('bayer',raw_pic);
    
    %% display all 8 images and histogram
    pr_showpics(raw_pic, color_pic, red_raw, green_raw, blue_raw);
    hist = histogram(color_pic, 1008);
    
    %% done working
    disp('Done.');
