function hist=histogram(color_img, fig_number)
    %% histogram generation and display function for PR
    %% expects RGB 3-plane color image and figure number
    %% displays histogram in specified figure
    
    %% create histogram matrix
    hist = zeros(1,256);
    
    %% get matrix size
    [n,m,p] = size(color_img);
    if (p ~= 3)
        error('Histogramming requires full RGB matrix on input.');
    end
    
    %% generate composite brightness matrix
    %% brightness of pixel = (.299*R)+(.587*G)+(.114*B)
    comp_brt = zeros(n,m);
    for x = 1:n;
        for y = 1:m;
            comp_brt(x,y) = round((.299*color_img(x,y,1))+(.587*color_img(x,y,2))+(.114*color_img(x,y,3)));
        end
    end
    
    %% sort by value composite brightness matrix
    for i = 0:1:255;
        s = 0;  
        for x = 1:n;
            for y = 1:m;
                if (comp_brt(x,y) == i);
                    s = s+1;
                end
            end 
        end
        s = s/(m*n);
        hist(1,(i+1)) = s;
    end
  
    %% now generate figure
    fig = figure(fig_number);
    set(fig, 'Resize', 'on');
    set(fig, 'Name', 'Peeping ROM - Image Histogram');
    set(fig, 'NumberTitle', 'off');
    axis image;
    bar(hist)
