function data = camera_usermode(mode)
    %% mode setup
    if (nargin == 0)
        mode = 'quiet'
    end

    %% camera automode setup:
    %% set 'enabled' to 'disabled', 'verbose' to 'quiet' if desired
    disp('-----');
    pr_modeset('AEC','enabled','AGC','enabled','AWB','enabled','verbose');
    disp('-----');
  
    %% perform user-specified camera changes here
    %% for register changes, use:
    %%      pr_regset(<reg#>,<value>,['verbose']);
    %% for bitset changes, use:
    %%      pr_bitset(<reg#>,<bit#>,<value>,['verbose']);
    %% for register READS only, use:
    %%      pr_regread(<reg#>);
    disp('Applying user-specified changes...');
    %% insert changes here
    disp('-----');
  
    %% register display during register settling period
    %% enable by calling camera_usermode('verbose')
    switch mode
        case 'verbose'
            disp('Registers displayed:');
            disp('time: 0x01 : 0x02 : 0x05 : 0x06 : 0x07 : 0x10 : 0x00');            
            for i = 10 : -1 : 1  
                bluegain = pr_get(hex2dec('01'));
                redgain = pr_get(hex2dec('02'));
                contrast = pr_get(hex2dec('05'));
                brightness = pr_get(hex2dec('06'));
                sharpness = pr_get(hex2dec('07'));
                autoexpose = pr_get(hex2dec('10'));
                gain = pr_get(hex2dec('00')); 
                disp(sprintf('  %02d:  %02X     %02X     %02X     %02X     %02X     %02X     %02X',[i,bluegain,redgain,contrast,brightness,sharpness,autoexpose,gain]));
                pause(1);
            end
        case 'quiet'
            disp('Please wait for register setup to finish (10 sec).')
            pause(10);
            disp('Setup completed.');
	    case 'no-delay'
	        disp('Warning: No delay period enabled!');
            pause(1);
            disp('Setup completed.');
        otherwise
            warning('Unknown argument to camera_usermode - using verbose mode...');
            disp('Registers displayed:');
            disp('time: 0x01 : 0x02 : 0x05 : 0x06 : 0x07 : 0x10 : 0x00');
            for i = 10 : -1 : 1  
                bluegain = pr_get(hex2dec('01'));
                redgain = pr_get(hex2dec('02'));
                contrast = pr_get(hex2dec('05'));
                brightness = pr_get(hex2dec('06'));
                sharpness = pr_get(hex2dec('07'));
                autoexpose = pr_get(hex2dec('10'));
                gain = pr_get(hex2dec('00'));
                disp(sprintf('  %02d:  %02X     %02X     %02X     %02X     %02X     %02X     %02X',[i,bluegain,redgain,contrast,brightness,sharpness,autoexpose,gain]));
                pause(1);
            end
    end
