function raw_data = camera_takepic()
    %% performs picture capture and download
    %% returns matrix with raw image info, post resizing
    %% into proper 349x288 image
    
    %% capture picture
    disp('Starting image capture...');
    pr_picture;
    disp('Image captured.');
    
    %% download image and resize
    disp('Downloading data...');
    t_start = clock;
    raw_data = reshape(pr_download(349*288),349,288)';
    download_time = etime(clock, t_start);
    disp(sprintf('Total download time: %d seconds.',[round(download_time)]));
    
    %% now close serial port
    pr_close;