function [r, g, b, or, og, ob] = bayer(c)
%%% Given n x m matrix of Bayer-patterned data from camera, return three
%%% n x m matrices representing the per-pixel interpolated RGB values.
%%% All data should be integers 0-255.  Interpolation is linear, and 
%%% expected pattern is
%%% G B G B G B
%%% R G R G R G
%%% G B G B G B
%%% R G R G R G
%%% written 01/2005 by Jim Paris <jim@jtan.com>
  [m,n] = size(c);
  if(m<2 | n<2) error('image too small'); end;
  r = zeros(m,n);
  g = zeros(m,n);
  b = zeros(m,n);
  
  xO = 1:2:n;   yO = 1:2:m;   % all odd indices
  xE = 2:2:n;   yE = 2:2:m;   % all even indices
  xo = 3:2:n-1; yo = 3:2:m-1; % odd indices except border
  xe = 2:2:n-1; ye = 2:2:m-1; % even indices except border

  %% Set known RGB values from Bayer pattern
  g(yO,xO) = c(yO,xO); b(yO,xE) = c(yO,xE);
  r(yE,xO) = c(yE,xO); g(yE,xE) = c(yE,xE);

  %% Provide the uninterpolated values to the user
  or = r;
  og = g;
  ob = b;

  %%%% Do the bulk of the interpolation:

  %% Interpolate red: 2 3
  %%                  R 1
  r(yE,xe) = (r(yE,xe-1) + r(yE,xe+1)) / 2;  % 1
  r(yo,xO) = (r(yo-1,xO) + r(yo+1,xO)) / 2;  % 2
  r(yo,xe) = (r(yo-1,xe-1) + r(yo-1,xe+1) + r(yo+1,xe-1) + r(yo+1,xe+1))/4; % 3

  %% Interpolate green: G 1
  %%                    2 G
  g(yo,xe) = (g(yo,xe-1) + g(yo,xe+1) + g(yo-1,xe) + g(yo+1,xe))/4; % 1
  g(ye,xo) = (g(ye,xo-1) + g(ye,xo+1) + g(ye-1,xo) + g(ye+1,xo))/4; % 2

  %% Interpolate blue: 1 B
  %%                   3 2
  b(yO,xo) = (b(yO,xo-1) + b(yO,xo+1)) / 2;  % 1
  b(ye,xE) = (b(ye-1,xE) + b(ye+1,xE)) / 2;  % 2
  b(ye,xo) = (b(ye-1,xo-1) + b(ye-1,xo+1) + b(ye+1,xo-1) + b(ye+1,xo+1))/4; % 3

  %%%% Now fix up the edge cases on the borders:

  %% Red: copy line to top, and maybe bottom and right
  r(1,:) = r(2,:);
  if( mod(m,2)) r(m,:) = r(m-1,:); end;
  if(~mod(n,2)) r(:,n) = r(:,n-1); end;

  %% Green: average three pixels at border: G 1 G
  %% This is the messy case.                2 G .
  %% First do top and left                  G . . 
  g(1,xe) = (g(2,xe) + g(1,xe-1) + g(1,xe+1))/3; % 1
  g(ye,1) = (g(ye,2) + g(ye-1,1) + g(ye+1,1))/3; % 2
  if(mod(m,2))  % Bottom is G 1 G 1
    g(m,xe) = (g(m-1,xe) + g(m,xe-1) + g(m,xe+1))/3; % 1
  else 	        % Bottom is 2 G 2 G 2 G
    g(m,1) = (g(m-1,1) + g(m,2))/2;   % bottom left corner
    g(m,xo) = (g(m-1,xo) + g(m,xo-1) + g(m,xo+1))/3; % 2
  end
  if(mod(n,2))  % Right is 1 G 1 G going down
    g(ye,n) = (g(ye,n-1) + g(ye-1,n) + g(ye+1,n))/3; % 1
  else          % Right is G 2 G 2 going down
    g(1,n) = (g(1,n-1) + g(2,n))/2;   % top right corner
    g(yo,n) = (g(yo,n-1) + g(yo-1,n) + g(yo+1,n))/3; % 1
  end
  if(xor(mod(m,2),mod(n,2))) 
    g(m,n) = (g(m,n-1) + g(m-1,n))/2; % bottom right corner
  end

  %% Blue: copy line to left, and maybe bottom and right
  b(:,1) = b(:,2);
  if(~mod(m,2)) b(m,:) = b(m-1,:); end;
  if( mod(n,2)) b(:,n) = b(:,n-1); end;

  %% Make it integers again.
  r = floor(r);
  g = floor(g);
  b = floor(b);
